<?php
/**
 * Gibt ein Array mit n dynamisch generierten, gut unterscheidbaren Farben (HEX) zurück.
 * Die Farben werden per HSL-Farbraum erzeugt und zufällig verteilt.
 *
 * @param int $n Anzahl der gewünschten Farben
 * @return array HEX-Farbcodes
 */
function trainingssystemGenerateColors($n) {
    $result = [];
    $random_offset = mt_rand(0, 359); // Zufälliger Startwert für den Farbkreis
    for ($i = 0; $i < $n; $i++) {
        $hue = ($random_offset + ($i * (360 / max(1, $n)))) % 360;
        $result[] = trainingssystemHslToHex($hue, 70, 50); // Sättigung 70%, Helligkeit 50%
    }
    shuffle($result);
    return $result;
}

/**
 * Wandelt HSL-Farbwerte in einen HEX-Farbcode um.
 *
 * @param float $h Hue (0-360)
 * @param float $s Sättigung (0-100)
 * @param float $l Helligkeit (0-100)
 * @return string HEX-Farbcode
 */
function trainingssystemHslToHex($h, $s, $l) {
    $s /= 100;
    $l /= 100;
    $c = (1 - abs(2 * $l - 1)) * $s;
    $x = $c * (1 - abs(fmod($h / 60, 2) - 1));
    $m = $l - $c / 2;
    if ($h < 60) {
        $r = $c; $g = $x; $b = 0;
    } elseif ($h < 120) {
        $r = $x; $g = $c; $b = 0;
    } elseif ($h < 180) {
        $r = 0; $g = $c; $b = $x;
    } elseif ($h < 240) {
        $r = 0; $g = $x; $b = $c;
    } elseif ($h < 300) {
        $r = $x; $g = 0; $b = $c;
    } else {
        $r = $c; $g = 0; $b = $x;
    }
    $r = round(($r + $m) * 255);
    $g = round(($g + $m) * 255);
    $b = round(($b + $m) * 255);
    return sprintf("#%02x%02x%02x", $r, $g, $b);
} 